const SWITCH_URL = "https://seth-c.com/onoroff.txt";

async function checkSwitch() {
  // Cache-bust so it updates instantly when you create/delete the file
  const url = `${SWITCH_URL}?t=${Date.now()}`;

  try {
    // HEAD is lighter, but some hosts mis-handle it.
    // We'll try HEAD first, then fall back to GET.
    let res = await fetch(url, { method: "HEAD", cache: "no-store" });
    if (!res.ok) {
      res = await fetch(url, { method: "GET", cache: "no-store" });
    }
    return res.ok; // true if 200-299
  } catch {
    return false; // network error => OFF (fail-safe)
  }
}

chrome.runtime.onMessage.addListener((msg, sender, sendResponse) => {
  if (msg?.type === "CHECK_SWITCH") {
    checkSwitch().then((on) => sendResponse({ on }));
    return true; // keep message channel open for async reply
  }
});
