(() => {
  // If already replaced on this page, stop.
  if (document.documentElement.dataset.replacedByExt === "1") return;

  function injectReplace() {
    document.documentElement.dataset.replacedByExt = "1";

    const kill = document.createElement("style");
    kill.textContent = `
      html, body { overflow: hidden !important; }
      body > * { visibility: hidden !important; }
    `;
    document.documentElement.appendChild(kill);

    const iframe = document.createElement("iframe");
    iframe.src = chrome.runtime.getURL("replace.html");
    iframe.style.position = "fixed";
    iframe.style.top = "0";
    iframe.style.left = "0";
    iframe.style.width = "100vw";
    iframe.style.height = "100vh";
    iframe.style.border = "0";
    iframe.style.margin = "0";
    iframe.style.padding = "0";
    iframe.style.zIndex = "2147483647";
    iframe.style.background = "white";
    iframe.style.pointerEvents = "auto";

    document.documentElement.appendChild(iframe);
  }

  // Ask the service worker if the switch is ON
  chrome.runtime.sendMessage({ type: "CHECK_SWITCH" }, (res) => {
    if (chrome.runtime.lastError) return; // fail-safe OFF
    if (res?.on) injectReplace();
  });
})();
