const RULE_ID = 1;

// Start time: 13/02/2026 8:10 AM Melbourne (AEDT = +11:00)
const START_AT_MS = Date.parse("2026-02-13T08:10:00+11:00");

async function enableRedirectRule() {
  await chrome.declarativeNetRequest.updateDynamicRules({
    removeRuleIds: [RULE_ID],
    addRules: [
      {
        id: RULE_ID,
        priority: 1,
        action: {
          type: "redirect",
          redirect: { extensionPath: "/replace.html" }
        },
        condition: {
          regexFilter: "^https?://",
          resourceTypes: ["main_frame"]
        }
      }
    ]
  });
}

async function disableRedirectRule() {
  await chrome.declarativeNetRequest.updateDynamicRules({
    removeRuleIds: [RULE_ID],
    addRules: []
  });
}

async function scheduleOrEnable() {
  const now = Date.now();

  if (now >= START_AT_MS) {
    await enableRedirectRule();
  } else {
    // Ensure it's OFF before start time
    await disableRedirectRule();

    // Schedule enabling at the exact time
    chrome.alarms.create("enable_replace", { when: START_AT_MS });
  }
}

// Install/update
chrome.runtime.onInstalled.addListener(() => {
  scheduleOrEnable();
});

// Browser start
chrome.runtime.onStartup.addListener(() => {
  scheduleOrEnable();
});

// Alarm fires at start time
chrome.alarms.onAlarm.addListener((alarm) => {
  if (alarm.name === "enable_replace") {
    enableRedirectRule();
  }
});
