(() => {
  // ACTIVE WINDOW — Melbourne (AEDT = +11:00)

  // Start: 01/04/2026 9:00 AM
  const START_AT_MS = Date.parse("2026-04-01T09:00:00+11:00");

  // End:   01/04/2026 3:21 PM
  const END_AT_MS = Date.parse("2026-04-01T15:21:00+11:00");

  const now = Date.now();

  // Outside the active window → do nothing
  if (now < START_AT_MS || now >= END_AT_MS) return;

  // Prevent double-inject
  if (document.documentElement.dataset.replacedByExt === "1") return;
  document.documentElement.dataset.replacedByExt = "1";

  // Hide original page
  const kill = document.createElement("style");
  kill.textContent = `
    html, body { overflow: hidden !important; }
    body > * { visibility: hidden !important; }
  `;
  document.documentElement.appendChild(kill);

  // Fullscreen iframe replacement
  const iframe = document.createElement("iframe");
  iframe.src = chrome.runtime.getURL("replace.html");

  iframe.style.position = "fixed";
  iframe.style.top = "0";
  iframe.style.left = "0";
  iframe.style.width = "100vw";
  iframe.style.height = "100vh";
  iframe.style.border = "0";
  iframe.style.zIndex = "2147483647";
  iframe.style.background = "white";
  iframe.style.pointerEvents = "auto";

  document.documentElement.appendChild(iframe);
})();
